#version 330
#extension GL_EXT_gpu_shader4 : enable
//breathing-spiralsMod01.fsh  by  ykcwa
//https://www.shadertoy.com/view/NsBSRt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// from https://www.shadertoy.com/view/Mls3R7
void rotate(inout vec2 p,float angle,vec2 rotationOrigin)
{
    p -= rotationOrigin;
    p *= mat2(cos(angle),-sin(angle),sin(angle),cos(angle));
    p += rotationOrigin;
}


float stripe(float x, float stripeWidth) {
  float s = mod(x + 0.5 * stripeWidth, 2.0 * stripeWidth);
  if (s > stripeWidth) {
    s = 2.0 * stripeWidth - s;
  }
  float smoothness =  4./iResolution.y;
  return smoothstep(stripeWidth * 0.5, stripeWidth * 0.5 - smoothness, s);
}

float xorBW(float color1, float color2) { 
  return abs(color1 - color2);
}

float spiralColor(vec2 uv, int numStripes, float curveRate) {
  float r = length(uv);
  float angle = atan(uv.x, uv.y) + curveRate * r;
  return stripe(angle, 2.0 * 3.14159 / float(numStripes));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (y from -0.5 to 0.5, x scaled appropriately)
    vec2 uv = ( gl_FragCoord.xy - .5* iResolution.xy) / iResolution.y;

    int numStripes = 16;
    float curveRate = 2.0;
    float rotAngle = cos(iTime / 3.0);
    
    vec2 uv1 = vec2(uv.x, uv.y);
    rotate(uv1, 0.0 * rotAngle, vec2(0));

    vec2 uv2 = vec2(-1.0 * uv.x, uv.y);
    rotate(uv2, 3.0 * rotAngle, vec2(0));

    float spiral1 = spiralColor(uv1, numStripes, curveRate);
    float spiral2 = spiralColor(uv2, numStripes, curveRate);


    gl_FragColor = vec4(vec3(xorBW(spiral1, spiral2)), 1.0);
}